ORCA/M Asm65816 2.1.0

0001 0D18                       eject 
0002 0D18                       TITLE '      READ command'
0003 0D18              *****************************************************************
0004 0D18              *
0005 0D18              * DRIVER CALL:  READ
0006 0D18              *
0007 0D18              * This call executes a read from the device.  Block devices must
0008 0D18              * validate the initial block number and that the request count is
0009 0D18              * an integral multiple of the block size.  In addition the block
0010 0D18              * number of each successive block must be validated as it is
0011 0D18              * accessed when an multiple block I/O transaction is in place.
0012 0D18              *
0013 0D18              * ENTRY: via a 'JSR'
0014 0D18              *       <drvr_dev_num = Device Number of current device being accessed
0015 0D18              *       <drvr_buf_ptr = Pointer to I/O buffer
0016 0D18              *       <drvr_blk_num = Initial block number
0017 0D18              *       <drvr_req_cnt = Number of bytes to be transferred
0018 0D18              *      <drvr_blk_size = Size of block to be accessed
0019 0D18              *      <drvr_tran_cnt = $00000000
0020 0D18              *               A Reg = Call Number
0021 0D18              *               X Reg = Undefined
0022 0D18              *               Y Reg = Undefined
0023 0D18              *             Dir Reg = GS/OS Direct Page
0024 0D18              *               B Reg = Undefined
0025 0D18              *               P Reg = N V M X D I Z C  E
0026 0D18              *                       x x 0 0 0 0 x x  0
0027 0D18              *
0028 0D18              * EXIT: via an 'RTS'
0029 0D18              *      <drvr_tran_cnt = Number of bytes transferred
0030 0D18              *               A Reg = Error code
0031 0D18              *               X Reg = Undefined
0032 0D18              *               Y Reg = Undefined
0033 0D18              *             Dir Reg = GS/OS Direct Page
0034 0D18              *               B Reg = Same as entry
0035 0D18              *               P Reg = N V M X D I Z C  E
0036 0D18              *                       x x 0 0 0 0 x 0  0  if no error
0037 0D18              *                       x x 0 0 0 0 x 1  0  if error
0038 0D18              *
0039 0D18              *****************************************************************
0040 0D18                       export read
0041 0D18              read     proc 
0042 0D18                       import Direct_Read             ;import the entry point
0043 0D18              DNIBTAB  EQU   $01BC00                  ;addres of page with dnibtab
0044 0D18                       longa on
0045 0D18                       longi on
0046 0D18
0047 0D18 20 67 05              jsr   check_access             ; did direct access occur?
0048 0D1B B0 3F                 bcs   read_exit                ; yes
0049 0D1D
0050 0D1D A5 0A                 lda   drvr_req_cnt+2
0051 0D1F 05 08                 ora   drvr_req_cnt             ;req count zero? (A = no_error)
0052 0D21 18                    clc   
0053 0D22 F0 38                 beq   read_exit
0054 0D24
0055 0D24 A5 14                 lda   <drvr_blk_size           ; validate the current block size
0056 0D26 C9 00 02              cmp   #$0200
0057 0D29 F0 32                 beq   chk_multi
0058 0D2B C9 0C 02              cmp   #$020C
0059 0D2E F0 05                 beq   chk_multiple
0060 0D30              bad_parm  
0061 0D30 A9 22 00              lda   #drvr_bad_parm           ; invalid block size
0062 0D33 38                    sec   
0063 0D34 60                    rts   
0064 0D35              *
0065 0D35              * Now call Int Math Toolset to do req_cnt DIV 524
0066 0D35              *
0067 0D35              chk_multiple  
0068 0D35 A6 0A                 ldx   <drvr_req_cnt+2
0069 0D37 30 F7                 bmi   bad_parm                 ;I don't do negative request counts for 524
0070 0D39 A9 00 00              lda   #0
0071 0D3C 48                    pha   
0072 0D3D 48                    pha   
0073 0D3E 48                    pha   
0074 0D3F 48                    pha   
0075 0D40 DA                    phx   
0076 0D41 D4 08                 pei   <drvr_req_cnt
0077 0D43 F4 00 00              pea   0000
0078 0D46 D4 14                 pei   <drvr_blk_size
0079 0D48 A2 0B 0D 22           _LongDivide                    ;call int math for the remainder
0080 0D4F 68                    pla                            ;discard quot
0081 0D50 68                    pla   
0082 0D51 68                    pla                            ;get remainder
0083 0D52 03 01                 ora   1,s                      ;get hi & lo word together in A
0084 0D54 FA                    plx   
0085 0D55 AA                    tax                            ;is remainder zero?
0086 0D56 F0 2F                 beq   do_read                  ; can't be 1:1 candidate if mac read
0087 0D58 A9 2C 00     bad_count lda   #drvr_bad_count         ; invalid byte count
0088 0D5B 38                    sec   
0089 0D5C 60           read_exit rts   
0090 0D5D              *
0091 0D5D              * Now see if this is a multi-block read candidate
0092 0D5D A5 08        chk_multi lda   <drvr_req_cnt
0093 0D5F 29 FF 01              and   #$01FF
0094 0D62 D0 F4                 bne   bad_count                ;insist req_cnt is divisible by 512
0095 0D64 EE 42 03              inc   total_reads              ;count all the 512 byte reads
0096 0D67 D0 03                 bne   @10
0097 0D69 EE 44 03              inc   total_reads+2
0098 0D6C              @10       
0099 0D6C              if NOT Version6x then  
0100 0D6C                       bit   ext_slot                 ;is slot external?
0101 0D6C                       bpl   @internal
0102 0D6C                       brl   do_read                  ;later this will do special multi-blk stuff
0103 0D6C              @internal  
0104 0D6C              endif     
0105 0D6C A5 09                 lda   drvr_req_cnt+1           ; Is this a multi-block read of at least 
0106 0D6E C9 0A 00              cmp   #512*5/256               ; half of the smallest 800K floppy track+1 sect?
0107 0D71 90 14                 bcc   do_read                  ;NO. too small for multi-track
0108 0D73 EE 46 03              inc   total_multiblk           ;count all the multiblk candidates
0109 0D76 D0 03                 bne   @20
0110 0D78 EE 48 03              inc   total_multiblk+2
0111 0D7B A5 1A        @20      lda   <drvr_cache              ; caching requested
0112 0D7D
0113 0D7D F0 60                 beq   multi_blkrd              ; NO. so do it mmmyyyyy waaaaayy@#$!eek
0114 0D7F
0115 0D7F EE 4A 03              inc   total_multidisq          ; count the ones disqualified for cache/dsw/etc
0116 0D82 D0 03                 bne   @30
0117 0D84 EE 4C 03              inc   total_multidisq+2
0118 0D87              @30       
0119 0D87                       eject 
0120 0D87              **********************************************************************
0121 0D87              *
0122 0D87              * The following routine is executed for read calls
0123 0D87              * directed toward class 2 block devices.
0124 0D87              *
0125 0D87              **********************************************************************
0126 0D87              do_read                                 ;
0127 0D87 24 16                 bit   <drvr_fst_num            ; force device access
0128 0D89 30 1A                 bmi   @dev_acc
0129 0D8B 18                    clc                            ; specify block search
0130 0D8C 22 04 FC 01           jsl   cache_find_blk           ; is the block in the cache?
0131 0D90 B0 1A                 bcs   @not_cached              ; no, may want to cache it though.
0132 0D92 22 B8 17 02           jsl   cache_to_buff            ; yes, read block from cache to buffer
0133 0D96 20 B0 16              jsr   c2_dev_stat              ; check for disk switched error
0134 0D99 B0 09                 bcs   @error
0135 0D9B              @no_purge                               ;
0136 0D9B              *
0137 0D9B              * Block has been read.  Need to adjust the block address
0138 0D9B              * and buffer pointer in preperation for the next read if
0139 0D9B              * a multiple block transaction is in process.  If the
0140 0D9B              * request count has been satisfied, no further action is required.
0141 0D9B              *
0142 0D9B 20 58 11              jsr   next_blk_ptr             ; prepare for next block & test if more
0143 0D9E 90 E7                 bcc   do_read                  ; more blocks to read
0144 0DA0 18                    clc                            ; all done with no errors
0145 0DA1 A9 00 00              lda   #no_error
0146 0DA4 60           @error   rts   
0147 0DA5              *
0148 0DA5              * If block is not in cache or volume ID is zero, must force
0149 0DA5              * access to the device to read the block.
0150 0DA5              *
0151 0DA5              @dev_acc                                ;
0152 0DA5 20 83 11              jsr   do_sp_readblk            ; execute device read
0153 0DA8 B0 FA                 bcs   @error                   ; if error from device
0154 0DAA 80 EF                 bra   @no_purge                ; and continue with transaction
0155 0DAC              *
0156 0DAC              * If block is not cached, action depends on the cache enable in the
0157 0DAC              * current call.  If the cache enable is zero then must force access
0158 0DAC              * to the device.  If cache enable is nonzero, a request for a block
0159 0DAC              * for caching must be made of the cache manager.  If no block is granted,
0160 0DAC              * then must force access to the device while reading only to the buffer.
0161 0DAC              * if the block is granted, the block is read from the device to the buffer
0162 0DAC              * and then transferred from the buffer to the cache.
0163 0DAC              *
0164 0DAC              @not_cached                             ; 
0165 0DAC A5 1A                 lda   <drvr_cache              ; is the cache enable OFF?
0166 0DAE F0 F5                 beq   @dev_acc                 ; yes, read but don't do caching
0167 0DB0 20 83 11              jsr   do_sp_readblk            ; execute device read
0168 0DB3 B0 EF                 bcs   @error                   ; if error from device
0169 0DB5 22 08 FC 01           jsl   cache_add_blk            ; request a block for caching
0170 0DB9 B0 04                 bcs   @no_cache
0171 0DBB 22 CD 17 02           jsl   buff_to_cache            ; copy data to the cache
0172 0DBF              @no_cache                               ; 
0173 0DBF 80 DA                 bra   @no_purge                ; and continue with transaction
0174 0DC1                       eject 
0175 0DC1              ;----------------------------------------
0176 0DC1              ; exit paths from multi-blkrd back to 
0177 0DC1              ; the original code to handle errors
0178 0DC1              ;----------------------------------------
0179 0DC1 C2 30        count_error REP   #$30
0180 0DC3 EE 4E 03              inc   total_multifail
0181 0DC6 D0 03                 bne   force_error
0182 0DC8 EE 50 03              inc   total_multifail+2
0183 0DCB                       longa off
0184 0DCB                       longi off
0185 0DCB E2 30        force_error SEP   #$30
0186 0DCD AF E8 C0 E1           lda   >deselect                ;deactivate drive enable and start timer
0187 0DD1 20 A7 17              jsr   phases_off
0188 0DD4 20 56 17              jsr   restore_slot6
0189 0DD7 C2 30        do_error REP   #$30
0190 0DD9                       longa on
0191 0DD9                       longi on
0192 0DD9 64 0C                 stz   drvr_tran_cnt
0193 0DDB 64 0E                 stz   drvr_tran_cnt+2          ;incase Direct_read was called
0194 0DDD 80 A8                 bra   do_read                  	; do it the hard way for some reason
0195 0DDF                       eject 
0196 0DDF              ****************************************************************
0197 0DDF              *
0198 0DDF              *   An UNcached read request of at least 5 blocks
0199 0DDF              *
0200 0DDF              ****************************************************************
0201 0DDF                       export multi_blkrd
0202 0DDF              multi_blkrd  
0203 0DDF A0 50 00              ldy   #dib_last_sts            ;was media offline last time?
0204 0DE2 B7 20                 lda   [drvr_dib_ptr],y
0205 0DE4 29 10 00              and   #%10000
0206 0DE7 F0 07                 beq   @doStatus                ;offline so do Status to get blockcount
0207 0DE9 A0 0A 00              ldy   #blk_cnt
0208 0DEC B7 20                 lda   [drvr_dib_ptr],y
0209 0DEE D0 09                 bne   @doRead
0210 0DF0 20 6A 0B     @doStatus jsr   Fixup_blkcnt            ;go do DevStat to see if blockcount is known
0211 0DF3 90 04                 bcc   @doRead                  ;status returned disk switch so ERROR the Read
0212 0DF5 8D B5 03              sta   multi_err
0213 0DF8 60                    rts                            ;return the disk switched/offline error
0214 0DF9              @doRead  equ   *
0215 0DF9
0216 0DF9              if Version6x then  
0217 0DF9 2C 68 03              bit   ext_slot
0218 0DFC 10 03                 bpl   @04                      ;if Internal slot
0219 0DFE 82 0A 01              brl   multi_blk_Ext
0220 0E01              @04      equ   *
0221 0E01              endif     
0222 0E01 A0 0A 00              ldy   #blk_cnt
0223 0E04 B7 20                 lda   [drvr_dib_ptr],y
0224 0E06 C9 40 06              cmp   #1600                    ;is this an 800K disk?
0225 0E09 D0 CC                 bne   do_error                 ;multi_blk only works for 800K disks
0226 0E0B
0227 0E0B E2 30                 SEP   #$30
0228 0E0D                       longa off
0229 0E0D                       longi off
0230 0E0D 20 69 14              jsr   FastBufr                 ; is buffer in bk0/1 with shadowing on?
0231 0E10 90 0A                 bcc   @05
0232 0E12 EE 4A 03              inc   total_multidisq
0233 0E15 D0 C0                 bne   do_error
0234 0E17 EE 4C 03              inc   total_multidisq+2
0235 0E1A 80 BB                 bra   do_error
0236 0E1C              *
0237 0E1C              * Save slot environment and enable the IWM and set DRIVE from DIB
0238 0E1C 20 25 17     @05      jsr   enable_slot6             ;activate /EN35 
0239 0E1F 20 A7 17              jsr   phases_off
0240 0E22 A0 0F                 ldy   #%00001111
0241 0E24 20 6D 17              jsr   IFf_set_mode             ;set mode if and only if mode reg available
0242 0E27 20 B8 15              jsr   enable_sense             ;enable drive and sense dsw/onl/mtr status
0243 0E2A 90 0A                 bcc   @09
0244 0E2C EE 4A 03              inc   total_multidisq
0245 0E2F D0 9A                 bne   force_error
0246 0E31 EE 4A 03              inc   total_multidisq
0247 0E34 80 95                 bra   force_error              ;since status is bad use sp to say so.
0248 0E36              *
0249 0E36              * The drive is enabled and does not have dsw or offline status 
0250 0E36              * so I must switch the IWM mode to do actual I/O to the media.
0251 0E36 A0 0F        @09      ldy   #%00001111
0252 0E38 20 82 17              jsr   set_iwm_mode             ;this time I have to wait if IWM busy
0253 0E3B              * activate the drive select which was dropped to change IWM modes
0254 0E3B AF E9 C0 E1           lda   >select
0255 0E3F              *
0256 0E3F              * If the motor was not on, turn is on now!
0257 0E3F 20 14 16              jsr   motoron                  ;if not on activate the motor
0258 0E42              *
0259 0E42              * Now setup all the parameters for ReadTrk and check to see
0260 0E42              * if the buffer spans any slow memory
0261 0E42                       longa on
0262 0E42                       longi on
0263 0E42 C2 30                 REP   #$30
0264 0E44 A5 12                 lda   drvr_blk_num+2
0265 0E46 D0 07                 bne   @bberrxit                ;blknum > 65535 is an error
0266 0E48 A5 10                 lda   drvr_blk_num
0267 0E4A 20 06 12              jsr   blockchker               ;block num in range?
0268 0E4D 90 18                 bcc   @10                      ;yep
0269 0E4F A9 2D 00     @bberrxit lda   #drvr_bad_block         ;return drvr_bad_blk error
0270 0E52 48           @Aerrxit pha   
0271 0E53                       longa off
0272 0E53                       longi off
0273 0E53 E2 30                 SEP   #$30
0274 0E55 AF E8 C0 E1           lda   >deselect                ;deactivate drive enable and start timer
0275 0E59 20 A7 17              jsr   phases_off
0276 0E5C 20 56 17              jsr   restore_slot6
0277 0E5F C2 30                 REP   #$30
0278 0E61                       longa on
0279 0E61                       longi on
0280 0E61 68                    pla   
0281 0E62 29 FF 00              and   #$00FF
0282 0E65 38                    sec   
0283 0E66 60                    rts   
0284 0E67              * Now calc block count and end blocknum
0285 0E67 A5 0A        @10      lda   <drvr_req_cnt+2
0286 0E69 29 00 FF              and   #$FF00
0287 0E6C D0 17                 bne   @17                      ;gigantic req_cnt !
0288 0E6E A5 09                 lda   <drvr_req_cnt+1
0289 0E70 4A                    lsr   a                        ;req_cnt div 512 = block cnt
0290 0E71 9C B5 03              stz   multi_err
0291 0E74 8D A7 03     @15      sta   block_cnt                ;
0292 0E77 18                    clc   
0293 0E78 65 10                 adc   drvr_blk_num
0294 0E7A B0 09                 bcs   @17                      ;any carry means end_blk_num > 65535
0295 0E7C 3A                    dec   a                        ;beg_blk+blk_cnt-1 ==> end_blk_num
0296 0E7D 8D A3 03              sta   end_blk_num
0297 0E80 20 06 12              jsr   blockchker               ;check end_blk_num is in range too!
0298 0E83 90 10                 bcc   @20                      ;block_cnt now not too big!!
0299 0E85 A9 2D 00     @17      lda   #drvr_bad_block
0300 0E88 8D B5 03              sta   multi_err                ;record this as if it happens at end of volume
0301 0E8B A0 0A 00              ldy   #blk_cnt
0302 0E8E B7 20                 lda   [drvr_dib_ptr],Y         ;get max block (last + 1)
0303 0E90 38                    sec   
0304 0E91 E5 10                 sbc   drvr_blk_num             ;subtract starting blk num
0305 0E93 80 DF                 bra   @15                      ;and use result as the blk cnt
0306 0E95              *
0307 0E95 AD A7 03     @20      lda   block_cnt                ;retrieve final block count
0308 0E98 0A                    asl   a                        ;turn into a byte count
0309 0E99 85 09                 sta   <drvr_req_cnt+1          ;make sure we only read this many bytes
0310 0E9B
0311 0E9B A6 10                 ldx   drvr_blk_num
0312 0E9D AD A3 03              lda   end_blk_num
0313 0EA0 85 10                 sta   drvr_blk_num
0314 0EA2              * Now X = beg_blk_num
0315 0EA2              *     A = end_blk_num
0316 0EA2              *     block_cnt is setup for MIN (req_cnt DIV 512 , MaxBlock - BeginBlk) 
0317 0EA2 20 0F 12              jsr   setup_readtrk            ;(restores drvr_blk_num)
0318 0EA5              ;
0319 0EA5                       longa off
0320 0EA5                       longi off
0321 0EA5 E2 30                 SEP   #$30
0322 0EA7              *
0323 0EA7              * Now Update my Cur_cyl from the firmware CurCyl
0324 0EA7 20 10 13              jsr   Get_CURCYL
0325 0EAA 08                    php   
0326 0EAB 68                    pla   
0327 0EAC 29 04                 and   #%00000100               ;extract IRQ disable bit
0328 0EAE 8D 6C 03              sta   irq_state                ;and save for the SEEK routine
0329 0EB1              *
0330 0EB1              * Do the lead-in seek here with interrupts ON if user left em that way
0331 0EB1 20 16 15              jsr   Seek                     ; and wait for Ready with interrupts ON?
0332 0EB4 90 07                 bcc   @seekok
0333 0EB6              @not_ready  
0334 0EB6 C2 30                 REP   #$30
0335 0EB8                       longa on
0336 0EB8 A9 2F 00              lda   #drvr_off_line
0337 0EBB 80 95                 bra   @Aerrxit
0338 0EBD                       longa off
0339 0EBD              *
0340 0EBD              * NOW INTERRUPTS MUST BE TURNED OFF TO READ the TRACKS
0341 0EBD              @seekok   
0342 0EBD 20 F4 15              jsr   Wait_Rdy_TO              ;ensure that the drive is ready
0343 0EC0 B0 F4                 bcs   @not_ready               ;oops
0344 0EC2 08                    php   
0345 0EC3 78                    sei                            ;disable interrupts 
0346 0EC4 20 46 13              jsr   Read_tracks              ;read the track/tracks 
0347 0EC7 08                    php                            ;save error status
0348 0EC8 20 2A 13              jsr   Put_CURCYL               ;update firmware CurCyl before irq allowd
0349 0ECB 28                    plp   
0350 0ECC 90 04                 bcc   @its_ok
0351 0ECE 28                    plp                            ;RESTORE interrupts
0352 0ECF 82 EF FE              brl   count_error              ;redo the read because of an error
0353 0ED2              *
0354 0ED2              * The ReadTrk worked so now do the ugly stuff
0355 0ED2              @its_OK   
0356 0ED2 AF E8 C0 E1           lda   >deselect                ;deactivate drive enable and start drive's timer
0357 0ED6 20 A7 17              jsr   phases_off
0358 0ED9 20 56 17              jsr   restore_slot6            ;now deactivate /EN35
0359 0EDC 28                    plp                            ;RESTORE interrupts
0360 0EDD              * NOW INTERRUPTS ARE BACK ON
0361 0EDD                       longa on
0362 0EDD                       longi on
0363 0EDD C2 30                 REP   #$30
0364 0EDF 64 0C                 stz   drvr_tran_cnt
0365 0EE1 64 0E                 stz   drvr_tran_cnt+2          ;clear out direct_read scratch garbage
0366 0EE3 AD A7 03              lda   block_cnt
0367 0EE6 0A                    asl   a                        ;make it a page cnt
0368 0EE7 85 0D                 sta   drvr_tran_cnt+1          ;set this incase dev_only access
0369 0EE9 A5 16                 lda   drvr_fst_num             ;did caller want only device access?
0370 0EEB 30 17                 bmi   @dev_rd_only             ;yep. so forget the slow stuff
0371 0EED 64 0D                 stz   drvr_tran_cnt+1          ;let next_blk_ptr re-fill this
0372 0EEF A9 02 00              lda   #0002
0373 0EF2 85 02                 sta   drvr_call_num            ;restore this too just in case
0374 0EF4              *
0375 0EF4              * now search the cache incase some of the blocks I read
0376 0EF4              * were in the cache and must be copied from cache to buffer
0377 0EF4 18                    clc                            ;for 1st time thru
0378 0EF5 22 04 FC 01  @cach_chk jsl   cache_find_blk          ;is the block in cache
0379 0EF9 B0 04                 bcs   @not_in_cache            ;it aint there try the next one
0380 0EFB 22 B8 17 02           jsl   cache_to_buff
0381 0EFF 20 58 11     @not_in_cache jsr   next_blk_ptr        ;update blk_num, buf_ptr, & tran_cnt
0382 0F02 90 F1                 bcc   @cach_chk
0383 0F04 AD B5 03     @dev_rd_only lda   multi_err            ;incase req count was too big
0384 0F07 C9 01 00              cmp   #1                       ;conditionalize carry properly
0385 0F0A 60                    rts   
0386 0F0B              if Version6x then  
0387 0F0B              **********************************************************************
0388 0F0B              *
0389 0F0B              *  Multi_blk Read for external slot "Mustang" cards
0390 0F0B              *
0391 0F0B              **********************************************************************
0392 0F0B              Multi_blk_Ext  
0393 0F0B                       longa on
0394 0F0B                       longi on
0395 0F0B
0396 0F0B              *
0397 0F0B              * Setup the slot's c800 space so I can talk to the Mustang cpu
0398 0F0B 20 1B 11              jsr   enable_slotN
0399 0F0E
0400 0F0E              * Now calc block count and end blocknum
0401 0F0E A5 0A                 lda   <drvr_req_cnt+2
0402 0F10 29 00 FF              and   #$FF00
0403 0F13 F0 10                 beq   @10                      ;gigantic req_cnt !
0404 0F15 A9 2D 00     @05      lda   #drvr_bad_block
0405 0F18 8D B5 03              sta   multi_err                ;record this as if it happens at end of volume
0406 0F1B A0 0A 00              ldy   #blk_cnt
0407 0F1E B7 20                 lda   [drvr_dib_ptr],Y         ;get max block (last + 1)
0408 0F20 38                    sec   
0409 0F21 E5 10                 sbc   drvr_blk_num             ;subtract starting blk num
0410 0F23 80 06                 bra   @15                      ;and use result as the blk cnt
0411 0F25              *
0412 0F25 A5 09        @10      lda   <drvr_req_cnt+1
0413 0F27 4A                    lsr   a                        ;req_cnt div 512 = block cnt
0414 0F28 9C B5 03              stz   multi_err
0415 0F2B 8D A7 03     @15      sta   block_cnt                ;
0416 0F2E 18                    clc   
0417 0F2F 65 10                 adc   drvr_blk_num
0418 0F31 B0 E2                 bcs   @05                      ;any carry means end_blk_num > 65535
0419 0F33 3A                    dec   a                        ;beg_blk+blk_cnt-1 ==> end_blk_num
0420 0F34 8D A3 03              sta   end_blk_num
0421 0F37 A0 0A 00              ldy   #blk_cnt
0422 0F3A D7 20                 cmp   [drvr_dib_ptr],y         ;is end > volume size?
0423 0F3C B0 D7                 bcs   @05                      ;yep. so limit to last block num
0424 0F3E
0425 0F3E A5 10                 lda   drvr_blk_num
0426 0F40 8D A1 03              sta   beg_blk_num
0427 0F43 A5 04                 lda   drvr_buf_ptr
0428 0F45 85 1C                 sta   drvr_buf2_ptr
0429 0F47 A5 06                 lda   drvr_buf_ptr+2
0430 0F49 85 1E                 sta   drvr_buf2_ptr+2          ;setup the starting buffer pointer
0431 0F4B A5 05                 lda   drvr_buf_ptr+1
0432 0F4D 8D 72 03              sta   basePgBk
0433 0F50              *     block_cnt is setup for MIN (req_cnt DIV 512 , MaxBlock - BeginBlk) 
0434 0F50 20 4C 11     Do_hunk  jsr   SelectBank0
0435 0F53 AD A7 03              lda   block_cnt
0436 0F56 8D B2 03              sta   Mu_blk_cnt
0437 0F59
0438 0F59 A2 0D 00              ldx   #NuM_CalcBlks
0439 0F5C 20 D2 10              jsr   Send_CPU_Cmd
0440 0F5F B0 24                 bcs   Anerror                  ;device Busy error!
0441 0F61
0442 0F61 A0 FF FF              ldy   #-1
0443 0F64 AF 01 C8 00  @waitReply1 lda   >c8_reply             ;16-bit fetch of 8-bit item
0444 0F68 29 80 00              and   #$0080
0445 0F6B F0 0A                 beq   replied1
0446 0F6D 5A                    phy   
0447 0F6E 7A                    ply   
0448 0F6F 88                    dey   
0449 0F70 D0 F2                 bne   @waitReply1
0450 0F72 A9 29 00     Rdbusyerr lda   #drvr_busy
0451 0F75 38           DSWexit  sec   
0452 0F76 60                    rts   
0453 0F77
0454 0F77 AF 56 C8 00  replied1 lda   >c8_error
0455 0F7B 29 FF 00              and   #$00FF
0456 0F7E F0 16                 beq   rd_the_hunk
0457 0F80 C9 2E 00              cmp   #drvr_disk_sw            ;if the error is Disk switched JOA 11/15/91
0458 0F83 F0 F0                 beq   DSWexit                  ;it must be reported my me NOW JOA 11/15/91
0459 0F85 29 FF 00     Anerror  and   #$00FF                   ; bad block/Offline/diskSwitched error
0460 0F88 8D B5 03              sta   multi_err
0461 0F8B EE 4A 03              inc   total_multidisq
0462 0F8E D0 03                 bne   @ferr
0463 0F90 EE 4A 03              inc   total_multidisq
0464 0F93 82 41 FE     @ferr    brl   do_error                 ;since somthin is bad use slow way.
0465 0F96
0466 0F96              rd_the_hunk equ   *
0467 0F96 AF 0B C8 00           lda   >c8_xfr_cnt
0468 0F9A 8D A9 03              sta   tail_cnt
0469 0F9D 8D B2 03              sta   Mu_blk_cnt
0470 0FA0 D0 03                 bne   @01
0471 0FA2 82 CD 00              brl   @done
0472 0FA5              @01       
0473 0FA5 A2 0E 00              ldx   #NuM_ReadNBlks
0474 0FA8 20 D2 10              jsr   Send_CPU_Cmd             ;when CPU is ready
0475 0FAB B0 C5                 bcs   Rdbusyerr
0476 0FAD              @cmdok   equ   *
0477 0FAD              *
0478 0FAD              * Now look for initial reply
0479 0FAD 08                    php   
0480 0FAE 78                    sei   
0481 0FAF A0 FF FF              ldy   #-1
0482 0FB2 AF 01 C8 00  @waitReply1 lda   >c8_reply             ;16-bit fetch of 8-bit item
0483 0FB6 89 80 00              bit   #$0080
0484 0FB9 F0 08                 beq   @replied1
0485 0FBB 5A                    phy   
0486 0FBC 7A                    ply   
0487 0FBD 88                    dey   
0488 0FBE D0 F2                 bne   @waitReply1
0489 0FC0 28                    plp   
0490 0FC1 80 AF                 bra   Rdbusyerr
0491 0FC3
0492 0FC3 28           @replied1 plp   
0493 0FC4 29 FF 00              and   #$00FF
0494 0FC7 D0 09                 bne   @get_blocks
0495 0FC9 AF 56 C8 00           lda   >c8_error
0496 0FCD 29 FF 00              and   #$00FF
0497 0FD0 D0 B3                 bne   Anerror
0498 0FD2              *
0499 0FD2              * Now start waiting for sectors
0500 0FD2              @get_blocks equ   *
0501 0FD2 9C A5 03              stz   block_ctr                ;
0502 0FD5 20 C6 10              jsr   SelectBank1
0503 0FD8
0504 0FD8 AF 00 CA 00  @wait_cnt lda   >cA_rcount
0505 0FDC 30 0E                 bmi   @booboo                  ;Oh Boy! the C800 space must ev gotn LOST
0506 0FDE F0 F8                 beq   @wait_cnt                ;it hasn't read any yet
0507 0FE0 C9 00 01              cmp   #$100                    ;was there an IOError or such?
0508 0FE3 B0 0C                 bcs   @BADNEWS                 ;its all fizzed up boys
0509 0FE5 CD A5 03              cmp   block_ctr
0510 0FE8 F0 EE                 beq   @wait_cnt                ;not ahead of my count
0511 0FEA B0 1E                 bcs   @scanrtbl                ;CPU's count is > mycounter
0512 0FEC              *  bad news boys something has switched out the c800 space
0513 0FEC C2 30        @booboo  rep   #$30                     ;force longa and longi
0514 0FEE 4C 72 0F              jmp   Rdbusyerr                ;cA_rcount is way out of range!
0515 0FF1
0516 0FF1 AE A9 03     @BADNEWS ldx   tail_cnt
0517 0FF4 E2 20                 sep   #$20
0518 0FF6                       longa off
0519 0FF6 BF 01 CA 00  @05      lda   >cA_rtable-1,x
0520 0FFA C9 A0                 cmp   #$A0                     ;is this the error code?
0521 0FFC B0 05                 bcs   @goterr                  ;either IO or Offline
0522 0FFE CA                    dex   
0523 0FFF D0 F5                 bne   @05
0524 1001 A9 27                 lda   #drvr_io_error           ;well report it as IO if all else fails
0525 1003 C2 20        @goterr  rep   #$20
0526 1005                       longa on
0527 1005 29 7F 00              and   #$007F                   ;zero unknown hi byte and $80 bit
0528 1008 38                    sec   
0529 1009 60                    rts                            ;WELL FOLKS    I AM OUTA HERE ___....---^^^"""
0530 100A              *
0531 100A              @scanrtbl equ   *
0532 100A AE A9 03              ldx   tail_cnt
0533 100D E2 20                 sep   #$20
0534 100F                       longa off
0535 100F BF 01 CA 00  @10      lda   >cA_rtable-1,x
0536 1013 F0 02                 beq   @20                      ;this one not read yet
0537 1015 10 05                 bpl   @fnd
0538 1017 CA           @20      dex   
0539 1018 D0 F5                 bne   @10
0540 101A              * Now What??? it said another block was done but the rtable doesn't say so
0541 101A 80 D0                 bra   @booboo
0542 101C
0543 101C 09 80        @fnd     ora   #$80
0544 101E 9F 01 CA 00           sta   >cA_rtable-1,x           ;mark this buffer as mooovvvveeeddd
0545 1022 C2 20                 rep   #$20
0546 1024                       longa on
0547 1024 29 7F 00              and   #$007F
0548 1027 CA                    dex                            ;convert index to relative block number (0..n-1)
0549 1028              *
0550 1028              * move the buffer given in A to relative block given by X
0551 1028 20 95 10              jsr   Move_blk_buffer
0552 102B
0553 102B EE A5 03              inc   block_ctr
0554 102E AD A5 03              lda   block_ctr
0555 1031 CD A9 03              cmp   tail_cnt
0556 1034 90 A2                 bcc   @wait_cnt
0557 1036
0558 1036              @next_hunk equ   *
0559 1036 AD A9 03              lda   tail_cnt
0560 1039 18                    clc   
0561 103A 6D A1 03              adc   beg_blk_num
0562 103D 8D A1 03              sta   beg_blk_num              ;add count to begin
0563 1040              *
0564 1040              * Now update the driver tran count and my hunk buffer pointer
0565 1040 AD A9 03              lda   tail_cnt                 ;get block count transferred
0566 1043 EB                    xba                            ;* 256
0567 1044 0A                    asl   a                        ;* 512
0568 1045 48                    pha                            ;save for ptr update
0569 1046 18                    clc   
0570 1047 65 0C                 adc   drvr_tran_cnt
0571 1049 85 0C                 sta   drvr_tran_cnt
0572 104B 90 02                 bcc   @sk1
0573 104D E6 0E                 inc   drvr_tran_cnt+2          ;move up to next 65K transferred
0574 104F AD 72 03     @sk1     lda   basePgBk
0575 1052 85 1D                 sta   drvr_buf2_ptr+1          ;restore pointer to begin of hunk buffer
0576 1054 68                    pla   
0577 1055 18                    clc   
0578 1056 65 1C                 adc   drvr_buf2_ptr
0579 1058 85 1C                 sta   drvr_buf2_ptr            ;don't use drvr_buf_ptr due to error restart
0580 105A 90 02                 bcc   @sk2
0581 105C E6 1E                 inc   drvr_buf2_ptr+2          ;move up to next bank
0582 105E A5 1D        @sk2     lda   drvr_buf2_ptr+1
0583 1060 8D 72 03              sta   basePgBk                 ;update base adrs upper 16 bits
0584 1063 AD A7 03              lda   block_cnt
0585 1066 38                    sec   
0586 1067 ED A9 03              sbc   tail_cnt                 ;subtract this hunk from remainder
0587 106A 8D A7 03              sta   block_cnt
0588 106D F0 03                 beq   @done                    ;remainder == ZERO so must be all done
0589 106F 82 DE FE              brl   Do_hunk                  ;do the next hunk of blocks
0590 1072
0591 1072 AD B5 03     @done    lda   multi_err
0592 1075 C9 01 00              cmp   #1                       ;conditionalize carry properly
0593 1078 60                    rts   
0594 1079
0595 1079              **********************************************************************
0596 1079              *       Select_BufX
0597 1079              *
0598 1079              *  INPUT:       X = is relative buffer for this hunk
0599 1079              *               A = buffer number of the buffer to select 
0600 1079              *               basePgBk contains page and bank start for this hunk
0601 1079              * OUTPUT:       C = which half of bank is the buffer (0 = $C8, 1 = $CA)
0602 1079              *
0603 1079              **********************************************************************
0604 1079              Select_BufX equ   *
0605 1079                       longa on
0606 1079                       longi on
0607 1079 9B                    txy   
0608 107A 29 1F 00              and   #$001F                   ;make sure result in 31 max
0609 107D 4A                    lsr   a                        ;convert buffer # into bank select
0610 107E
0611 107E 08                    php                            ;save carry for result
0612 107F
0613 107F 0D B9 03              ora   Slotx16                  ;combine  $00S0 with $000b
0614 1082 AA                    tax   
0615 1083 E2 20                 sep   #$20
0616 1085                       longa off
0617 1085 BF 80 C0 00           lda   >$C080,x                 ;select the bank of RAM with the buffer
0618 1089 C2 20                 rep   #$20
0619 108B                       longa on
0620 108B 98                    tya                            ;get relative block number in A
0621 108C 0A                    asl   a                        ;calc relative page offset (
0622 108D 18                    clc   
0623 108E 6D 72 03              adc   basePgBk
0624 1091 85 1D                 sta   drvr_buf2_ptr+1          ;set the pointer for this block
0625 1093
0626 1093 28                    plp                            ;get carry back for caller
0627 1094 60                    rts   
0628 1095
0629 1095              **********************************************************************
0630 1095              *
0631 1095              *  Move Block Buffer to User Buffer
0632 1095              *
0633 1095              *  INPUT:       A = buffer to move
0634 1095              *               X = relative block number
0635 1095              *
0636 1095              **********************************************************************
0637 1095              Move_blk_buffer equ   *
0638 1095                       longa on
0639 1095                       longi on
0640 1095
0641 1095 20 79 10              jsr   Select_BufX              ;select buffer and set Y per buffer offset
0642 1098              * return C = 0 for $C800 buffer and C=1 for $CA00 buffer
0643 1098 8B                    phb   
0644 1099 F4 00 00              pea   0000
0645 109C AB                    plb   
0646 109D AB                    plb                            ;set data bank for bank for 00
0647 109E A0 FE 01              ldy   #512-2
0648 10A1 B0 12                 bcs   @cAloop
0649 10A3 B9 00 C8     @c8loop  lda   $C800,y
0650 10A6 97 1C                 sta   [drvr_buf2_ptr],y
0651 10A8 88                    dey                            ;$1FD
0652 10A9 88                    dey                            ;$1FC,F8,F4,F0, ... 0004,0000
0653 10AA B9 00 C8              lda   $C800,y
0654 10AD 97 1C                 sta   [drvr_buf2_ptr],y
0655 10AF 88                    dey                            ;$1FB
0656 10B0 88                    dey                            ;$1FA,F6,F2,FE, ... 0002,FFFE
0657 10B1 10 F0                 bpl   @c8loop
0658 10B3 80 10                 bra   @done
0659 10B5
0660 10B5 B9 00 CA     @cAloop  lda   $CA00,y
0661 10B8 97 1C                 sta   [drvr_buf2_ptr],y
0662 10BA 88                    dey   
0663 10BB 88                    dey   
0664 10BC B9 00 CA              lda   $CA00,y
0665 10BF 97 1C                 sta   [drvr_buf2_ptr],y
0666 10C1 88                    dey   
0667 10C2 88                    dey   
0668 10C3 10 F0                 bpl   @cAloop
0669 10C5              @done    equ   *
0670 10C5 AB                    plb                            ;restore data bank
0671 10C6              *       |       |       |
0672 10C6              *       v       v       v       fall thru into SelectBank1 for exit
0673 10C6              **********************************************************************
0674 10C6              * Select Mustang RAM bank 1 for xfer loop
0675 10C6              **********************************************************************
0676 10C6              SelectBank1 equ   *
0677 10C6 AE B9 03              ldx   Slotx16
0678 10C9 E2 20                 sep   #$20
0679 10CB                       longa off
0680 10CB BF 81 C0 00           lda   >$C081,X
0681 10CF C2 20                 rep   #$20
0682 10D1                       longa on
0683 10D1 60                    rts   
0684 10D2
0685 10D2              **********************************************************************
0686 10D2              *
0687 10D2              * Send Cmd to NuMustang CPU
0688 10D2              *
0689 10D2              *  INPUT:       x = cmdnum to send
0690 10D2              *
0691 10D2              *  ASSUMES:     SelectBank0 has been called
0692 10D2              *               Other parameters are already setup
0693 10D2              **********************************************************************
0694 10D2              Send_CPU_Cmd equ   *
0695 10D2                       longa on
0696 10D2                       longi on
0697 10D2
0698 10D2 AD A1 03              lda   beg_blk_num
0699 10D5 8D AE 03              sta   Mu_blk_num
0700 10D8 9C B0 03              stz   Mu_blk_num+2
0701 10DB A0 30 00              ldy   #unit_num
0702 10DE
0703 10DE E2 20                 sep   #$20
0704 10E0                       longa off
0705 10E0              * 8-bit A mode
0706 10E0 B7 20                 lda   [drvr_dib_ptr],y
0707 10E2 8D AC 03              sta   Mu_unitnum
0708 10E5 8A                    txa   
0709 10E6 09 40                 ora   #$40
0710 10E8 8D AB 03              sta   Mu_cmdmode               ;make it an "extended" call
0711 10EB
0712 10EB A0 FF FF              ldy   #-1
0713 10EE AF 00 C8 00  @waitCPUrdy lda   >c8_cmd_msg           ;+5
0714 10F2 30 09                 bmi   @rdy1                    ;+7
0715 10F4 5A                    phy   
0716 10F5 7A                    ply   
0717 10F6 88                    dey                            ;+9
0718 10F7 D0 F5                 bne   @waitCPUrdy              ;+12
0719 10F9 A9 29                 lda   #drvr_busy
0720 10FB 38                    sec   
0721 10FC 60                    rts   
0722 10FD
0723 10FD DA           @rdy1    phx   
0724 10FE A2 08 00              ldx   #9-1
0725 1101 BD AB 03     @mvMu_parms lda   Mu_cmdmode,x
0726 1104 9F 02 C8 00           sta   >c8_parms,x
0727 1108 CA                    dex   
0728 1109 10 F6                 bpl   @mvMu_parms
0729 110B
0730 110B A9 FF                 lda   #$FF
0731 110D 8F 01 C8 00           sta   >c8_reply                ;clear the reply
0732 1111 68                    pla   
0733 1112 8F 00 C8 00           sta   >c8_cmd_msg
0734 1116 68                    pla                            ; (pull upper half of phx above (longi is ON!!!)
0735 1117
0736 1117              * 16-bit A mode
0737 1117 C2 20                 rep   #$20
0738 1119                       longa on
0739 1119 18                    clc   
0740 111A 60                    rts   
0741 111B
0742 111B
0743 111B              **********************************************************************
0744 111B              *
0745 111B              * Enable SlotN's C800 space 
0746 111B              *
0747 111B              **********************************************************************
0748 111B                       longa on
0749 111B                       longi on
0750 111B              Enable_SlotN  
0751 111B A0 2E 00              ldy   #slot_num
0752 111E B7 20                 lda   [drvr_dib_ptr],y         ;get slot number
0753 1120 29 07 00              and   #$0007
0754 1123 09 C0 00              ora   #$00C0                   ;A = $00CN
0755 1126
0756 1126 08                    php   
0757 1127 78                    sei                            ;interrupts off for a moment
0758 1128
0759 1128 E2 20                 sep   #$20
0760 112A                       longa off
0761 112A
0762 112A 8F F8 07 00           sta   >mslot                   ;set mslot to $Cn for interrupt restore of C8space
0763 112E EB                    xba   
0764 112F AF FF CF 00           lda   >$CFFF                   ;(8-bit fetch) switch out all c800 spaces
0765 1133 A9 00                 lda   #00                      ; A = $Cs00
0766 1135
0767 1135 C2 20                 rep   #$20
0768 1137                       longa on
0769 1137
0770 1137 AA                    tax   
0771 1138 BF 00 00 00           lda   >0,x                     ;(2 8-bit fetches) switch in the desired slot's c800 space
0772 113C 8E B7 03              stx   Cn00
0773 113F 28                    plp                            ;restore interrupts
0774 1140 8A                    txa   
0775 1141 EB                    xba   
0776 1142 29 07 00              and   #0007
0777 1145 0A                    asl   a
0778 1146 0A                    asl   a
0779 1147 0A                    asl   a
0780 1148 0A                    asl   a
0781 1149 8D B9 03              sta   Slotx16                  ;contains $00s0 where s = slot number
0782 114C              *       |       |       |   fall thru into Select Bank 0
0783 114C              *       v       v       v
0784 114C              **********************************************************************
0785 114C              * Select Bank 0 
0786 114C              *
0787 114C              **********************************************************************
0788 114C                       longa on
0789 114C                       longi on
0790 114C              SelectBank0 equ   *
0791 114C AE B9 03              ldx   Slotx16
0792 114F E2 20                 sep   #$20
0793 1151                       longa off
0794 1151 BF 80 C0 00           lda   >$C080,X
0795 1155 C2 20                 rep   #$20
0796 1157                       longa on
0797 1157 60                    rts   
0798 1158              endif     
0799 1158
0800 1158                       eject 
0801 1158              *****************************************************************
0802 1158              *
0803 1158              * The following routine is used to increment the block # and ptr
0804 1158              * in preperation for the next I/O transaction. Then the transfer
0805 1158              * count is compared to the request count with the carry set as a
0806 1158              * result of the compare.
0807 1158              *
0808 1158              * ENTRY:        A Reg = Unspecified
0809 1158              *               X Reg = Unspecified
0810 1158              *               Y Reg = Unspecified
0811 1158              *               B Reg = Unspecified
0812 1158              *             Dir Reg = GS/OS Direct Page
0813 1158              *               P Reg = N V M X D I Z C  E
0814 1158              *                       x x 0 0 0 x x x  0
0815 1158              *
0816 1158              * EXIT:         A Reg = Unspecified
0817 1158              *               X Reg = drvr_blk_size
0818 1158              *               Y Reg = Unspecified
0819 1158              *               B Reg = Same as entry
0820 1158              *             Dir Reg = GS/OS Direct Page
0821 1158              *               P Reg = 16 bit 'm' & 'x'
0822 1158              *               P Reg = N V M X D I Z C  E
0823 1158              *                       x x 0 0 0 x x 1  0 if transfer count ³ request count
0824 1158              *                       x x 0 0 0 x x 0  0 if transfer count < request count
0825 1158              *
0826 1158              *****************************************************************
0827 1158                       export next_blk_ptr
0828 1158              next_blk_ptr                            ;
0829 1158                       longa on
0830 1158                       longi on
0831 1158
0832 1158 18                    clc                            ; adjust buffer pointer
0833 1159 A5 14                 lda   <drvr_blk_size
0834 115B AA                    TAX   
0835 115C 65 04                 adc   <drvr_buf_ptr
0836 115E 85 04                 sta   <drvr_buf_ptr
0837 1160 A9 00 00              lda   #$0000
0838 1163 65 06                 adc   <drvr_buf_ptr+2
0839 1165 85 06                 sta   <drvr_buf_ptr+2
0840 1167
0841 1167 E6 10                 inc   <drvr_blk_num            ; point at next block
0842 1169 D0 02                 bne   @10
0843 116B E6 12                 inc   <drvr_blk_num+2
0844 116D              @10                                     ;
0845 116D 18                    clc                            ; update transfer count
0846 116E 8A                    TXA   
0847 116F 65 0C                 adc   <drvr_tran_cnt
0848 1171 85 0C                 sta   <drvr_tran_cnt
0849 1173 A9 00 00              lda   #$0000
0850 1176 65 0E                 adc   <drvr_tran_cnt+2
0851 1178 85 0E                 sta   <drvr_tran_cnt+2
0852 117A C5 0A                 cmp   <drvr_req_cnt+2          ; compare MSB trans to req
0853 117C 90 04                 bcc   @20
0854 117E A5 0C                 lda   <drvr_tran_cnt           ; compare LSB trans to req
0855 1180 C5 08                 cmp   <drvr_req_cnt
0856 1182 60           @20      rts                            ; carry set if I/O transaction done
0857 1183
0858 1183
0859 1183                       eject 
0860 1183              *****************************************************************
0861 1183              *
0862 1183              * The following routine executes a readblock from the SmartPort
0863 1183              * device.
0864 1183              *
0865 1183              * ENTRY:        A Reg = Undefined
0866 1183              *               X Reg = Undefined
0867 1183              *               Y Reg = Undefined
0868 1183              *               B Reg = Same as program bank
0869 1183              *             Dir Reg = GS/OS Direct Page
0870 1183              *               P Reg = N V M X D I Z C  E
0871 1183              *                       x x 0 0 0 x x x  0
0872 1183              *
0873 1183              * EXIT:         A Reg = Undefined
0874 1183              *               X Reg = Undefined
0875 1183              *               Y Reg = Undefined
0876 1183              *               B Reg = Unchanged
0877 1183              *             Dir Reg = GS/OS Direct Page
0878 1183              *               P Reg = N V M X D I Z C  E
0879 1183              *                       x x 0 0 0 x x 0  0 if no error
0880 1183              *                       x x 0 0 0 x x 1  0 if error
0881 1183              *
0882 1183              *****************************************************************
0883 1183                       export do_sp_readblk
0884 1183              do_sp_readblk  
0885 1183                       longa on
0886 1183                       longi on
0887 1183
0888 1183 20 B0 11              jsr   setup_sp_call            ; setup SmartPort call parameters
0889 1186
0890 1186 A0 50 00              ldy   #dib_last_sts            ;was media offline last time?
0891 1189 B7 20                 lda   [drvr_dib_ptr],y
0892 118B 29 10 00              and   #%10000
0893 118E F0 07                 beq   @doStatus                ;offline so do Status to get blockcount
0894 1190 A0 0A 00              ldy   #blk_cnt
0895 1193 B7 20                 lda   [drvr_dib_ptr],y
0896 1195 D0 05                 bne   @doRead
0897 1197 20 6A 0B     @doStatus jsr   Fixup_blkcnt            ;go do DevStat to see if blockcount is known
0898 119A B0 13                 bcs   @dswErr                  ;status returned disk switch so ERROR the Read
0899 119C
0900 119C A5 00        @doRead  lda   <drvr_dev_num            ; device number to read
0901 119E A6 14                 ldx   <drvr_blk_size           ;which block size to do?
0902 11A0 E0 0C 02              cpx   #$020C                   ;a mac write?
0903 11A3 A2 40 04              ldx   #blockread_list
0904 11A6 90 03                 bcc   @10                      ;NO.
0905 11A8 A2 5E 04              ldx   #readbyts_list           ;yes.
0906 11AB 22 80 FC 01  @10      jsl   to_b0_core
0907 11AF 60           @dswErr  rts   
0908 11B0                       eject 
0909 11B0              *****************************************************************
0910 11B0              *
0911 11B0              * The following routine sets up call parameters in the SmartPort
0912 11B0              * parameter lists for both the readblock and writeblock SmartPort
0913 11B0              * device calls.
0914 11B0              *
0915 11B0              * ENTRY:        A Reg = Undefined
0916 11B0              *               X Reg = Undefined
0917 11B0              *               Y Reg = Undefined
0918 11B0              *               B Reg = Same as program bank
0919 11B0              *             Dir Reg = GS/OS Direct Page
0920 11B0              *               P Reg = N V M X D I Z C  E
0921 11B0              *                       x x 0 0 0 x x x  0
0922 11B0              *
0923 11B0              * EXIT:         A Reg = Undefined
0924 11B0              *               X Reg = Undefined
0925 11B0              *               Y Reg = Undefined
0926 11B0              *               B Reg = Unchanged
0927 11B0              *             Dir Reg = GS/OS Direct Page
0928 11B0              *               P Reg = N V M X D I Z C  E
0929 11B0              *                       x x 0 0 0 x x x  0
0930 11B0              *
0931 11B0              *****************************************************************
0932 11B0                       export setup_sp_call
0933 11B0                       longa on
0934 11B0                       longi on
0935 11B0              setup_sp_call  
0936 11B0 A5 10                 lda   <drvr_blk_num            ; setup block number for SmartPort call
0937 11B2 8D 4B 04              sta   blockrd_blk
0938 11B5 8D 5A 04              sta   blockwr_blk
0939 11B8 8D 6B 04              sta   rdbyts_blk
0940 11BB 8D 7C 04              sta   wrbyts_blk
0941 11BE A5 12                 lda   <drvr_blk_num+2
0942 11C0 8D 4D 04              sta   blockrd_blk+2
0943 11C3 8D 5C 04              sta   blockwr_blk+2
0944 11C6 8D 6D 04              sta   rdbyts_blk+2
0945 11C9 8D 7E 04              sta   wrbyts_blk+2
0946 11CC
0947 11CC A5 04                 lda   <drvr_buf_ptr            ; setup buffer pointer for SmartPort call
0948 11CE 8D 47 04              sta   blockrd_buf
0949 11D1 8D 56 04              sta   blockwr_buf
0950 11D4 8D 65 04              sta   rdbyts_buf
0951 11D7 8D 76 04              sta   wrbyts_buf
0952 11DA A5 06                 lda   <drvr_buf_ptr+2
0953 11DC 8D 49 04              sta   blockrd_buf+2
0954 11DF 8D 58 04              sta   blockwr_buf+2
0955 11E2 8D 67 04              sta   rdbyts_buf+2
0956 11E5 8D 78 04              sta   wrbyts_buf+2
0957 11E8 A5 14                 lda   <drvr_blk_size
0958 11EA 8D 69 04              sta   rdbyts_count
0959 11ED 8D 7A 04              sta   wrbyts_count
0960 11F0              ; now setup the smartport unit number from the DIB
0961 11F0 A0 30 00              ldy   #unit_num                ; get unit number from DIB
0962 11F3 E2 20                 sep   #$20                     ; 8 bit 'm'
0963 11F5                       longa off
0964 11F5
0965 11F5 B7 20                 lda   [<drvr_dib_ptr],y
0966 11F7 8D 46 04              sta   blockrd_unit             ; install in read call list
0967 11FA 8D 55 04              sta   blockwr_unit             ; install in write call list
0968 11FD 8D 64 04              sta   rdbyts_unit
0969 1200 8D 75 04              sta   wrbyts_unit
0970 1203
0971 1203 C2 20                 rep   #$20                     ; 16 bit 'm'
0972 1205                       longa on
0973 1205 60                    rts   
0974 1206
0975 1206              *****************************************************************
0976 1206              *                                                               *
0977 1206              *  blockchker     Check the 16-bit A-reg against the DIB        *
0978 1206              *                                                               *
0979 1206              *    This routine checks the block in the A-reg to see          *
0980 1206              *  if it is within the correct bounds for disk volume size      *
0981 1206              *                                                               *
0982 1206              *   Regs:   A,Y  destroyed                                      *
0983 1206              *           C <-- 1 if block out of range ; 0 otherwise         *
0984 1206              *                                                               *
0985 1206              *****************************************************************
0986 1206                       longa on
0987 1206                       longi on
0988 1206 A0 0A 00     BlockChker ldy   #blk_cnt
0989 1209 D7 20                 cmp   [drvr_dib_ptr],Y         ;
0990 120B 90 01                 bcc   @exit
0991 120D 38                    sec   
0992 120E 60           @exit    rts   
0993 120F                       eject 
0994 120F              *****************************************************************
0995 120F              *  Do all the setup calculations for the Read_tracks variables
0996 120F              *
0997 120F              * ENTRY:        A Reg = end_blk_num
0998 120F              *               X Reg = drvr_blk_num
0999 120F              *               Y Reg = Undefined
1000 120F              *               P Reg = N V M X D I Z C  E
1001 120F              *                       x x 0 0 0 x x x  0
1002 120F              *
1003 120F              * EXIT:         A,X,Y = Undefined
1004 120F              *               P Reg = N V M X D I Z C  E
1005 120F              *                       x x 0 0 0 x x x  0  
1006 120F              *****************************************************************
1007 120F                       export setup_readtrk
1008 120F                       longa on
1009 120F                       longi on
1010 120F DA           Setup_ReadTrk phx   
1011 1210 20 7D 12              jsr   blkmap                   ;convert end_blk_num to track,sector
1012 1213 8D AF 03              sta   end_sector
1013 1216 8C A1 03              sty   end_track
1014 1219 FA                    plx   
1015 121A 86 10                 stx   drvr_blk_num
1016 121C 20 7D 12              jsr   blkmap                   ;convert beg_blk_num to track,sector
1017 121F E2 30                 SEP   #$30
1018 1221 20 CE 12              jsr   tracksect                ;convert track in Y into curnsect in A
1019 1224 8D 88 03              sta   curnsect                 ;save sect/beg_track
1020 1227 C2 30                 REP   #$30
1021 1229              * now Calc the track cnt
1022 1229 AD A1 03              lda   end_track
1023 122C 38                    sec   
1024 122D ED 80 03              sbc   track
1025 1230 1A                    inc   a
1026 1231 8D AB 03              sta   trk_ctr                  ;trk_ctr is number of tracks
1027 1234 A8                    tay                            ;for testing 1 track case
1028 1235              ; now setup all the parameters
1029 1235 AD A7 03              lda   block_cnt
1030 1238 8D A5 03              sta   block_ctr                ;set up count down for Read_Tracks
1031 123B              ;
1032 123B AD AF 03              lda   end_sector
1033 123E 1A                    inc   a                        ;E.G. if last sector #= 3 tail cnt = 4
1034 123F 8D A9 03              sta   tail_cnt                 ; this may not get used if 1 trk case
1035 1242 AA                    tax                            ;save end_sector+1
1036 1243 AD 7E 03              lda   sector
1037 1246 8D AD 03              sta   begin_sect               ;start at the beginning 
1038 1249              ;
1039 1249 AD 88 03              lda   curnsect                 ;get sects/begin_track
1040 124C C0 01 00              cpy   #0001                    ;are all the sectors on 1 track?
1041 124F D0 01                 bne   @30                      ;no.
1042 1251 8A                    txa                            ;for 1 trk case use end_sector+1 instead of curnsect
1043 1252 38           @30      sec   
1044 1253 ED AD 03              sbc   begin_sect               ;calc sectors on 1 track
1045 1256 8D B1 03              sta   read_ctr
1046 1259              ;
1047 1259                       longa off
1048 1259                       longi off
1049 1259 E2 30        @40      SEP   #$30                     ;8 bit native
1050 125B A2 00                 ldx   #00
1051 125D A9 40                 lda   #$40                     ;assume begin_sect is > 0
1052 125F EC AD 03     @50      cpx   begin_sect
1053 1262 90 02                 bcc   @60
1054 1264 A9 80                 lda   #$80                     ;now fill to (if trk_cnt > 1 then curnsect) 
1055 1266 C0 01        @60      cpy   #0001                    ;      or to (if trk_cnt = 1 then tail_cnt)
1056 1268 D0 07                 bne   @70
1057 126A EC A9 03              cpx   tail_cnt
1058 126D 90 02                 bcc   @70
1059 126F A9 40                 LDA   #$40                     ;if partial 1 trk case fill to end with don't want
1060 1271 9D 8F 03     @70      sta   want_fnd_tbl,x
1061 1274 E8                    inx   
1062 1275 EC 88 03              cpx   curnsect                 ;am I done yet?
1063 1278 90 E5                 bcc   @50
1064 127A C2 30                 REP   #$30
1065 127C                       longa on
1066 127C                       longi on
1067 127C 60                    rts   
1068 127D
1069 127D                       TITLE   '     Block Mapping Routine'    
1070 127D              ********************************************************
1071 127D              *
1072 127D              *  BlkMap           Map the block number to
1073 127D              *                   cyl, track, sector, & side
1074 127D              *
1075 127D              * Assumes:    800K  only and BlkChk has been called 1st
1076 127D              * 
1077 127D              *   Input:    drvr_blk_num <- block to convert
1078 127D              *   Output:   track, cyl, sector, side
1079 127D              *   Uses:     TrackSect
1080 127D              *   Regs:     A <- sector
1081 127D              *             Y <- track
1082 127D              *   Destroys: X, temp
1083 127D              * 
1084 127D              ********************************************************
1085 127D                       longa on
1086 127D                       longi on
1087 127D              *
1088 127D              * Preserve the low order six bits
1089 127D E2 30        BLKMAP   SEP   #$30
1090 127F                       longa off
1091 127F                       longi off
1092 127F A5 10                 LDA   drvr_blk_num
1093 1281 29 3F                 AND   #$3F
1094 1283 8D 7E 03              STA   SECTOR
1095 1286              *
1096 1286              * Obtain a table driven "guess" for the track, sector.
1097 1286              *  Get index into table with CmdBlock div 64.
1098 1286 A5 10                 LDA   drvr_blk_num             ;
1099 1288 8D 78 03              STA   TEMP                     ;dexxxxxx
1100 128B A5 11                 LDA   drvr_blk_num+1           ;0000 0abc  (max of 06)
1101 128D 2E 78 03              ROL   TEMP
1102 1290 2A                    ROL   A                        ;0000 abcd
1103 1291 2E 78 03              ROL   TEMP
1104 1294 2A                    ROL   A                        ;000abcde = Block DIV 64
1105 1295              *
1106 1295              * If this disk is 800K GCR offset to second half
1107 1295              *  of the track and sector tables.
1108 1295              @10      EQU   *
1109 1295 AA                    TAX                            ;        set up table index
1110 1296 BD F7 12              LDA   SECTAB,X                 ; sector number
1111 1299 48                    PHA                            ;        save it
1112 129A BD DE 12              LDA   TRACKTAB,X               ; track number
1113 129D A8                    TAY                            ;        save it
1114 129E 68                    PLA                            ;        restore sector number
1115 129F              *
1116 129F              * Y now has the track and A has the sector of the
1117 129F              *  requested CmdBlock with the low six bits clear.
1118 129F              *  Now we add the low six bits and correct an 
1119 129F              *  illegal mapping by subtracting off tracks
1120 129F              *  of sectors.
1121 129F 18                    CLC   
1122 12A0 6D 7E 03              ADC   SECTOR
1123 12A3 48           @20      PHA                            ;PRESERVE        the sector number 
1124 12A4 20 CE 12              JSR   TRACKSECT                ;A <- # sectors on current track 
1125 12A7 8D 78 03              STA   TEMP                     ;Keep A 
1126 12AA 68                    PLA                            ;PULL    back sector number 
1127 12AB CD 78 03              CMP   TEMP                     ;Bigger than # on this track? 
1128 12AE 90 06                 BLT   @30                      ;No: block's been mapped ; branch 
1129 12B0 C8                    INY                            ;NEXT    track 
1130 12B1 ED 78 03              SBC   TEMP                     ;Subtract # sectors that track 
1131 12B4 80 ED                 BRA   @20                      ;Try again 
1132 12B6              *
1133 12B6              * Acc now has the sector, and X now has the track. 
1134 12B6              *  In the case of a two sided disk, the track is
1135 12B6              *  actually twice the cylinder, so correct for that.
1136 12B6              *
1137 12B6              ********************************************
1138 12B6              *  Note that the carry is clear here.   ****
1139 12B6 8C 82 03     @30      STY   CYL
1140 12B9 8C 80 03              sty   track                    ;save cyl+side
1141 12BC 8D 7E 03              STA   SECTOR
1142 12BF              *
1143 12BF              * The track (A) is really the cylinder*2 plus the side.
1144 12BF              *  -> CCCCCCCS. Div by two puts cyl->A and side->carry.
1145 12BF 4E 82 03              LSR   CYL                      ;convert track to cyl and set 
1146 12C2 9C 7C 03              stz   side
1147 12C5 6E 7C 03              ROR   SIDE                     ;side = 00 or $80
1148 12C8                       longa on
1149 12C8                       longi on
1150 12C8 C2 30                 REP   #$30
1151 12CA AD 7E 03              LDA   SECTOR                   ;return 16 bits
1152 12CD 60                    RTS   
1153 12CE              **************************************************
1154 12CE              *                                                *
1155 12CE              *  TrackSect        Determine the number of      *
1156 12CE              *                       sectors for a cylinder   *
1157 12CE              *                                                *
1158 12CE              *   Input:    Y <- the track                     *
1159 12CE              *             X <- the drive                     *
1160 12CE              *   Output:   A <- number of sectors this cyl    *
1161 12CE              *             class <- speed group (0-4)         *
1162 12CE              *   Prsrves:  X & Y (carry is set)               *
1163 12CE              *   Max time: 16 microsec  (2MHZ)                *
1164 12CE              *                                                *
1165 12CE              **************************************************
1166 12CE                       longa off
1167 12CE                       longi off
1168 12CE 98           TRACKSECT TYA   
1169 12CF 4A                    LSR   A                        ;map trk (0..159) to cyl (0..79)
1170 12D0              *
1171 12D0                       export CYLSECT
1172 12D0 4A           CYLSECT  LSR   A                        ;Alt entry for A <- cyl 
1173 12D1 4A                    LSR   A
1174 12D2 4A                    LSR   A
1175 12D3 4A                    LSR   A
1176 12D4 8D 84 03              STA   CLASS 
1177 12D7 A9 0C                 LDA   #12
1178 12D9 38                    SEC   
1179 12DA ED 84 03              SBC   CLASS                    ; 12-(0,1,2,3,4)=12..8
1180 12DD 60                    RTS                            ;A has # of sectors per track
1181 12DE              *
1182 12DE              *
1183 12DE              * This table contains the track number of blocks with
1184 12DE              *  the low six bits clear.  Table has 25 entries for
1185 12DE              *  a double sided 800K format diskette.
1186 12DE              *
1187 12DE 00 05 0A 10  TRACKTAB DC B:0,5,10,16,21,26,32,37,43,49
1188 12E8 37 3D 43 49           DC B:55,61,67,73,80,86,92,99,106,113 
1189 12F2 78 80 88 90           DC B:120,128,136,144,152
1190 12F7              *
1191 12F7              * This is the sector table.
1192 12F7 00 04 08 00  SECTAB   DC B:0,4,8,0,4,8,0,9,7,5 
1193 1301 03 01 02 06           DC B:3,1,2,6,0,4,8,5,6,7 
1194 130B 08 00 00 00           DC B:8,0,0,0,0       
1195 1310
1196 1310                       TITLE '     GET & PUT CURCYL to cyr_cyl'    
1197 1310              *****************************************************************
1198 1310              * The following routine extracts CURCYL from firmware $E1 bank
1199 1310              * variables and sets cur_cyl table
1200 1310              *
1201 1310              * ENTRY:        A Reg = Undefined
1202 1310              *               X Reg = Undefined
1203 1310              *               Y Reg = Undefined
1204 1310              *               P Reg = N V M X D I Z C  E
1205 1310              *                       x x 1 1 0 x x x  0
1206 1310              *
1207 1310              * EXIT:         A Reg = Undefined
1208 1310              *               X Reg = unchanged
1209 1310              *               Y Reg = unchanged
1210 1310              *               P Reg = N V M X D I Z C  E
1211 1310              *                       x x 1 1 0 x x x  0 
1212 1310              *
1213 1310              *****************************************************************
1214 1310                       export Get_CurCyl
1215 1310                       longa off
1216 1310                       longi off
1217 1310 C2 20        Get_CurCyl REP   #$20
1218 1312                       longa on
1219 1312 AD 66 03              lda   rom_version
1220 1315 C9 02 00              cmp   #0002
1221 1318 B0 06                 bge   @10
1222 131A AF 22 0F E1           lda   $E10F22                  ;rev 01 rom stores this here
1223 131E 80 04                 bra   @20
1224 1320 AF 3A 0F E1  @10      lda   $E10F3A                  ;rev 03 rom stores this here
1225 1324 8D 52 03     @20      sta   cur_cyl
1226 1327                       longa off
1227 1327 E2 20                 SEP   #$20
1228 1329 60                    rts   
1229 132A              *****************************************************************
1230 132A              * The following routine updates CURCYL in firmware $E1 bank
1231 132A              * variables from my  cur_cyl table
1232 132A              *
1233 132A              * ENTRY:        A Reg = Undefined
1234 132A              *               X Reg = Undefined
1235 132A              *               Y Reg = Undefined
1236 132A              *               P Reg = N V M X D I Z C  E
1237 132A              *                       x x 1 1 0 x x x  0
1238 132A              *
1239 132A              * EXIT:         A Reg = Undefined
1240 132A              *               X Reg = drive
1241 132A              *               Y Reg = unchanged
1242 132A              *               P Reg = N V M X D I Z C  E
1243 132A              *                       x x 1 1 0 x x x  0 
1244 132A              *
1245 132A              *****************************************************************
1246 132A                       export Put_CurCyl
1247 132A                       longa on
1248 132A AE 86 03     Put_CurCyl ldx   drive
1249 132D C2 20                 REP   #$20
1250 132F AD 66 03              lda   rom_version
1251 1332 C9 02 00              cmp   #0002
1252 1335                       longa off
1253 1335 E2 20                 SEP   #$20
1254 1337 BD 52 03              lda   cur_cyl,x
1255 133A B0 05                 bcs   @10
1256 133C 9F 22 0F E1           sta   $E10F22,x                ;rev 01 rom stores this here
1257 1340 60                    rts   
1258 1341 9F 3A 0F E1  @10      sta   $E10F3A,x                ;rev 03 rom stores this here
1259 1345 60                    rts   
1260 1346                              TITLE   '     Read n Partial/whole Tracks'      
1261 1346              ******************************************************
1262 1346              * Reads all the sectors on one side of a track into a 
1263 1346              * buffer.  The routine allows for 1 
1264 1346              * retry per sector (2 revs max) to read all sectors.
1265 1346              *
1266 1346              * If a TRKREAD fails for any reason the read must be
1267 1346              * retried sector by sector since on 1 retry per sector
1268 1346              * is performed.
1269 1346              ******************************************************
1270 1346              ;  Assumed
1271 1346              ;  1) that volume is online and been checked for dsw
1272 1346              ;  2) the motor is up to speed and the drive is READY
1273 1346              ;  3) that the TRACK, TRKCNT, SECT_CNT, WANT_FND_TBL, 
1274 1346              ;     READRET, BEGIN_SECT, and TAIL_CNT have been setup. 
1275 1346              ;  4) that drvr_buf_ptr points to a contiguous buffer
1276 1346              ;     large enough to contain SECT_CNT sectors 
1277 1346              ;  5) that the sectors will be positioned in the buffer
1278 1346              ;     in ordinal order by sector number beginning with 
1279 1346              ;     BEGIN_SECT of TRACK 
1280 1346              ;  6) IF trackcnt > 2 Then all sectors must be 'wanted'
1281 1346              ;     for the tracks other than begin and end tracks.
1282 1346              ******************************************************
1283 1346                       longa on
1284 1346                       longi on
1285 1346                       export read_tracks
1286 1346 C2 30        Read_tracks REP   #$30
1287 1348 A5 05                 LDA   drvr_buf_ptr+1
1288 134A 8D 70 03              STA   BASESAVE                 ;save original base pg +bk
1289 134D                       longa off
1290 134D                       longi off
1291 134D E2 30                 SEP   #$30
1292 134F A5 04                 lda   drvr_buf_ptr
1293 1351 85 1C                 sta   drvr_buf2_ptr            ;low byte to 2nd pg pointer
1294 1353              ; Track loop begins here
1295 1353 AD 80 03     @RDTRK   LDA   TRACK
1296 1356 C9 A0                 CMP   #160
1297 1358 B0 4A                 BCS   @IOERR                   ;oops. an idiot caller!!
1298 135A 9C 7C 03              STZ   SIDE
1299 135D 4A                    LSR   A                        ;extract a side bit
1300 135E 8D 82 03              STA   CYL                      ;save cyl for seek
1301 1361 6E 7C 03              ROR   SIDE                     ; set side = $00/$80
1302 1364              *
1303 1364              * Convert cyl to curnsect (sects/trk) and setup readret, adrsret
1304 1364 AE 86 03              ldx   drive
1305 1367 AD 82 03              lda   cyl
1306 136A 20 D0 12              jsr   cylsect                  ;convert cyl to sects/trk
1307 136D 8D 88 03              sta   CURNSECT                 ;determine current sects/trk
1308 1370 AC B1 03              ldy   read_ctr                 ;was this input or should I fill it in?
1309 1373 D0 03                 bne   @03                      ;input provided so use it
1310 1375 8D B1 03              sta   read_ctr                 ;must not be first/last track.
1311 1378 0A           @03      ASL   A
1312 1379 1A                    INC   A                        ;plus 1
1313 137A 8D 76 03              STA   ADRSRET                  ;save curnsect*2 as limit ctr
1314 137D 9C B3 03              STZ   found_ctr
1315 1380              *
1316 1380              * Set up the maximum number of reseeks
1317 1380 A9 02                 LDA   #02
1318 1382 8D 74 03              STA   SEEKRET
1319 1385              *
1320 1385              * Now save drvr_buf_ptr page+bank address
1321 1385                       longa on
1322 1385 C2 20                 REP   #$20
1323 1387 A5 05                 LDA   drvr_buf_ptr+1
1324 1389 8D 72 03              STA   basepgbk
1325 138C                       longa off
1326 138C E2 20                 SEP   #$20
1327 138E              *
1328 138E              * Seek to the cylinder in cyl
1329 138E              @30      EQU   *
1330 138E 20 16 15              JSR   SEEK                     ;
1331 1391 90 26                 BCC   @50                      ;If no error, get an adr field 
1332 1393 C9 2F                 CMP   #drvr_off_line           ;timeout after waiting 700ms for a seek???
1333 1395 F0 0F                 beq   @seterr                  ;yes!
1334 1397 80 06                 bra   @35
1335 1399              *
1336 1399              * Seeked to the wrong cylinder.  Use the cylinder
1337 1399              *  number found to define our current position. 
1338 1399              @SEEKERR EQU   *
1339 1399 AE 86 03              LDX   DRIVE
1340 139C 9D 52 03              STA   cur_cyl,X                ;Use cyl found as reference
1341 139F              *
1342 139F              * There was a seek error ("hard" or "soft"). Maintain seek counter
1343 139F              @35      EQU   *
1344 139F CE 74 03              DEC   SEEKRET
1345 13A2 D0 EA                 BNE   @30                      ;Maybe try a reseek 
1346 13A4              *
1347 13A4              * Set the fatal error flag
1348 13A4              @IOERR   EQU   *
1349 13A4 A9 27                 LDA   #drvr_io_error           ;just back down to 1 blk at a time code
1350 13A6 C2 30        @SETERR  REP   #$30
1351 13A8                       longi on
1352 13A8                       longa on
1353 13A8 29 FF 00              AND   #$00FF                   ;clear hi byte of a for caller
1354 13AB AE 70 03              LDX   BASESAVE
1355 13AE 86 05                 STX   drvr_buf_ptr+1           ;restore zpg
1356 13B0                       longa off
1357 13B0                       longi off
1358 13B0 E2 30                 SEP   #$30
1359 13B2 38                    SEC   
1360 13B3 60                    RTS   
1361 13B4              *
1362 13B4              * Count down the address retry counter
1363 13B4 CE 76 03     @40      DEC   ADRSRET
1364 13B7 F0 EB                 BEQ   @IOERR
1365 13B9              *
1366 13B9              * Okay, read an address field
1367 13B9              @50      EQU   *
1368 13B9 20 93 14              JSR   RDADDR
1369 13BC 90 06                 BCC   @60
1370 13BE C9 28                 cmp   #ADRERROR+DBSERROR       ;was err bit slip or chksum?
1371 13C0 B0 F2                 bcs   @40                      ;yes. so retry it once
1372 13C2 80 E0                 BRA   @IOERR                   ;no. either timeout or SSfmt err.
1373 13C4              *
1374 13C4              * Now, see if this is the cylinder we expected 
1375 13C4              @60      EQU   *
1376 13C4 AD 8C 03              LDA   SIDEFND                  ;00S0000t 
1377 13C7 4A                    LSR   A                        ;000S0000 t->c
1378 13C8 AD 8E 03              LDA   TRKFND
1379 13CB 90 02                 BCC   @66
1380 13CD 09 40                 ORA   #$40
1381 13CF CD 82 03     @66      CMP   CYL
1382 13D2 D0 C5                 BNE   @SEEKERR
1383 13D4              *
1384 13D4              * Is side found what we thought?
1385 13D4              @70      EQU   *
1386 13D4 A9 20                 LDA   #$20
1387 13D6 2D 8C 03              AND   SIDEFND                  ;00s00000
1388 13D9 0A                    ASL   A                        ;0s000000
1389 13DA 0A                    ASL   A                        ;s0000000
1390 13DB 4D 7C 03              EOR   SIDE                     ;0&0,1&1 leaves 0
1391 13DE 30 D4                 BMI   @40                      ;treat this like adrs err
1392 13E0              *
1393 13E0              * don't double read a sector if it read correctly before
1394 13E0 AE 8D 03              LDX   SECTFND
1395 13E3 3C 8F 03              BIT   WANT_FND_TBL,X           ;Have I found or do I want this sector?
1396 13E6 70 CC                 BVS   @40                      ;Don't want this one so keep looking
1397 13E8 10 CA                 BPL   @40                      ;Already found this one so keep looking
1398 13EA              *
1399 13EA              * Calc the Direct read addresses 
1400 13EA                       longa on
1401 13EA                       longi on
1402 13EA C2 30                 REP   #$30
1403 13EC 8A                    TXA                            ;  (== ldx sectfnd)
1404 13ED 38                    SEC   
1405 13EE ED AD 03              SBC   begin_sect               ;in case this is partial track read
1406 13F1 0A                    ASL   A                        ;sect# * 2 is offset in pages
1407 13F2 6D 72 03              ADC   basepgbk                 ; add offset to page&bank
1408 13F5 85 05                 STA   drvr_buf_ptr+1
1409 13F7 1A                    INC   A
1410 13F8 85 1D                 STA   drvr_buf2_ptr+1          ;set the ptr for 2nd page
1411 13FA E2 30                 SEP   #$30
1412 13FC                       longa off
1413 13FC                       longi off
1414 13FC              *
1415 13FC              * Now Direct read this sector into the buffer
1416 13FC AD 8D 03              lda   sectfnd
1417 13FF 22 18 BD 01           jsl   Direct_read              ;read direct to user buffer
1418 1403 B0 AF                 bcs   @40                      ;bad read. so get the next one
1419 1405 EE B3 03              inc   found_ctr                ;count sectors (blocks) I read
1420 1408              *
1421 1408              * record that this sector has been read into users buffer
1422 1408 AE 8D 03              LDX   SECTFND                  ;
1423 140B 9E 8F 03              STZ   WANT_FND_TBL,X
1424 140E C2 20                 REP   #$20
1425 1410 CE A5 03              DEC   block_ctr                ;all blocks (up to 640 of em) done?
1426 1413 E2 20                 SEP   #$20
1427 1415 F0 44                 BEQ   @99                      ;yes. so forget this noise
1428 1417 CE B1 03              DEC   read_ctr                 ;is this track done?
1429 141A D0 98                 BNE   @40                      ;no. so cnt adrs and read next sector
1430 141C CE AB 03              DEC   trk_ctr                  ;any more tracks to do?
1431 141F F0 3A                 BEQ   @99                      ;nope.
1432 1421              *
1433 1421              * now adjust track and drvr_buf_ptr pointer 
1434 1421 EE 80 03              INC   TRACK                    ;increment to next cyl+side
1435 1424                       longa on
1436 1424 C2 20                 REP   #$20
1437 1426 AD B3 03              LDA   found_ctr                ;get sects/trk I just read in
1438 1429 0A                    ASL   A                        ;sects * 2 = pagecnt I red
1439 142A 18                    CLC   
1440 142B 6D 72 03              ADC   basepgbk
1441 142E 85 05                 STA   drvr_buf_ptr+1
1442 1430 E2 20                 SEP   #$20
1443 1432                       longa off
1444 1432 9C AD 03              stz   begin_sect               ;start next track at sect 00
1445 1435              *
1446 1435              * clear the sector want_found table for next full/partial track
1447 1435 A0 0C                 ldy   #12
1448 1437 84 0C                 sty   csum
1449 1439 9C B1 03              stz   read_ctr
1450 143C AD AB 03              lda   trk_ctr                  ;is this the last track?
1451 143F 3A                    dec   a
1452 1440 D0 08                 bne   @80                      ;nope. so read em all
1453 1442 AD A9 03              lda   tail_cnt                 ;yep. so set NOT wanted until tail_cnt
1454 1445 8D B1 03              sta   read_ctr
1455 1448 85 0C                 sta   csum
1456 144A A9 40        @80      LDA   #$40
1457 144C C4 0C        @84      cpy   csum
1458 144E D0 02                 bne   @88
1459 1450 A9 80                 LDA   #$80                     ;set 'doread' status from cnt-1..0
1460 1452 88           @88      DEY   
1461 1453 99 8F 03              STA   want_fnd_tbl,Y
1462 1456 D0 F4                 BNE   @84                      ;fill table with the status
1463 1458 82 F8 FE              BRL   @RDTRK                   ;and read this track
1464 145B C2 30        @99      REP   #$30
1465 145D                       longi on
1466 145D                       longa on
1467 145D 29 FF 00              and   #$00FF
1468 1460 AE 70 03              LDX   BASESAVE
1469 1463 86 05                 STX   drvr_buf_ptr+1 
1470 1465                       longa off
1471 1465                       longi off
1472 1465 E2 30                 SEP   #$30
1473 1467 18                    CLC   
1474 1468 60                    RTS   
1475 1469                       EJECT 
1476 1469              **************************************************
1477 1469              * FastBufr
1478 1469              *
1479 1469              * FastBufr determines if the user buffer address
1480 1469              * is in fast memory or if the 512 bytes spans a
1481 1469              * bank boundary
1482 1469              *
1483 1469              *    INPUT :  cmdbuffl+1,+2 is user buffer adrs
1484 1469              *    OUTPUT: DRswtch =  00 if bk spanned or slow (shadowed)
1485 1469              *            DRswtch = $FF if fast and not bk spanned 
1486 1469              *
1487 1469              ***************************************************
1488 1469                       longa off
1489 1469                       longi off
1490 1469              FASTBUFR EQU   *
1491 1469 A4 06                 LDY   drvr_buf_ptr+2
1492 146B C0 E0                 CPY   #$E0
1493 146D 90 04                 BCC   @10
1494 146F C0 E2                 CPY   #$E1+1
1495 1471 90 1E                 BCC   @SLOW
1496 1473 C0 02        @10      CPY   #02
1497 1475 90 02                 BCC   @15
1498 1477 80 16                 BRA   @FAST                    ;02..DF and E2..FF
1499 1479              *now test the bank 00 and 01 cases
1500 1479 AF 35 C0 00  @15      LDA   >SHADOW
1501 147D 29 3E                 AND   #$3E
1502 147F C9 3E                 CMP   #$3E                     ;all fast with TenSpeed CYA (nee FPI)?
1503 1481 F0 0C                 BEQ   @FAST                    ;yep
1504 1483 C9 1E                 CMP   #$1E                     ;all fast with GS FPI?
1505 1485 D0 0A                 BNE   @SLOW                    ;no. forget it
1506 1487 A6 05                 LDX   drvr_buf_ptr+1
1507 1489 E0 0C                 CPX   #$0C                     ;is buffer above txtpg2?
1508 148B B0 02                 BCS   @FAST                    ;yep. it safe
1509 148D 80 02                 BRA   @SLOW                    ;nope. might be TenSpeed with txtpg2 shadowing on
1510 148F 18           @FAST    CLC   
1511 1490 60                    RTS   
1512 1491 38           @SLOW    SEC   
1513 1492 60                    RTS   
1514 1493
1515 1493                       TITLE '     Read Address Field'
1516 1493              **************************************************
1517 1493              * 
1518 1493              *  rdaddr                Read an address field
1519 1493              *                                 with timeout
1520 1493              * 
1521 1493              *   Output:   sectinfo[0..4] of sector found
1522 1493              *             c=0 Read OK
1523 1493              *             c=1 Read BAD 
1524 1493              *       A-reg   Cause
1525 1493              *       $20     Single Sided Format
1526 1493              *       $24     Timeout no Adrs Mark
1527 1493              *       $28     Bit slip error
1528 1493              *       $30     CheckSum error
1529 1493              *   Destroys: A, X, Y, temp
1530 1493              * 
1531 1493              **************************************************
1532 1493                       longa off
1533 1493                       longi off
1534 1493                       export RDADDR
1535 1493              RDADDR    
1536 1493              *
1537 1493              * Set IWM into read mode
1538 1493 20 01 15              JSR   RDMODE                   ;Set read mode & hdsel
1539 1496              *
1540 1496              * Set up the timeout
1541 1496 A9 07                 LDA   #>AMTOUT
1542 1498 8D 78 03              STA   TEMP
1543 149B A0 9E                 LDY   #<AMTOUT
1544 149D              *
1545 149D              * Find the 3  marks nybbles
1546 149D A2 02        @10      LDX   #2                       ;Three of 'em
1547 149F 88           @20      DEY                            ;MAINTAIN        double byte t.o. ctr
1548 14A0 D0 05                 BNE   @30                      ;=> no timeout
1549 14A2 CE 78 03              DEC   TEMP
1550 14A5 30 4C                 BMI   @TOERR                   ;Oops, timeout error
1551 14A7              * 
1552 14A7 AF EC C0 E1  @30      LDA   >L6CLR                   ;Look for a byte
1553 14AB 10 FA                 BPL   @30                      ;Branch if no byte ready
1554 14AD DD BD 03              CMP   ADRMARKS,X               ;Is it the right mark? 
1555 14B0 D0 EB                 BNE   @10                      ;No, start all over 
1556 14B2 CA                    DEX                            ;YES,    found a mark 
1557 14B3 10 EA                 BPL   @20                      ;If more marks, go back 
1558 14B5              *
1559 14B5              * Found an address field. Now grab the info
1560 14B5              *
1561 14B5 A0 04                 LDY   #4                       ;Four pieces of info + csum
1562 14B7 64 0C                 STZ   CSUM
1563 14B9 AF EC C0 E1  @40      LDA   >L6CLR                   ;Get a byte
1564 14BD 10 FA                 BPL   @40                      ;If not ready, back again
1565 14BF AA                    TAX                            ;
1566 14C0 BF 00 BC 01           LDA   >DNIBTAB,X               ;Perform 8 to 6 bit xform 
1567 14C4 99 8A 03              STA   SECTINFO,Y               ;Save that chunk 
1568 14C7 45 0C                 EOR   CSUM                     ;Add into the checksum
1569 14C9 85 0C                 STA   CSUM
1570 14CB 88                    DEY                            ;ONE     less piece of info
1571 14CC 10 EB                 BPL   @40                      ;If more, go back
1572 14CE              *
1573 14CE              * The last byte was the checksum. If our calculated
1574 14CE              *  checksum is not zero now, we've had a problem
1575 14CE              *
1576 14CE A8                    TAY   
1577 14CF D0 26                 BNE   @CSERR
1578 14D1              *
1579 14D1              * Now identify the bitslip marks
1580 14D1              *
1581 14D1 AF EC C0 E1  @50      LDA   >L6CLR
1582 14D5 10 FA                 BPL   @50
1583 14D7 CD C5 03              CMP   BSLIP1
1584 14DA D0 1F                 BNE   @BSERR
1585 14DC              *
1586 14DC AF EC C0 E1  @60      LDA   >L6CLR
1587 14E0 10 FA                 BPL   @60
1588 14E2 CD C4 03              CMP   BSLIP2
1589 14E5 D0 14                 BNE   @BSERR
1590 14E7              *
1591 14E7 AE 86 03              LDX   DRIVE
1592 14EA AD 8B 03              LDA   FMTFND                   ;extract the DS bit from Fmt 
1593 14ED 29 20                 AND   #$20
1594 14EF F0 0C                 beq   @ERR                     ;error if its NOT double sided format!!!
1595 14F1              *
1596 14F1 18                    CLC                            ;GOT     a good sector
1597 14F2 60                    RTS   
1598 14F3              *
1599 14F3 A9 04        @TOERR   LDA   #TOERROR
1600 14F5 80 06                 bra   @err
1601 14F7 A9 10        @CSERR   LDA   #DCSERROR
1602 14F9 80 02                 bra   @err
1603 14FB A9 08        @BSERR   LDA   #DBSERROR
1604 14FD 09 20        @ERR     ORA   #ADRERROR                ;$20=ssfmt, $24=timeout, $28=BSlip, $30=Cksum
1605 14FF 38                    SEC   
1606 1500 60                    RTS   
1607 1501              *
1608 1501              *
1609 1501              RDMODE   EQU   *
1610 1501 AF EE C0 E1           LDA   >L7CLR
1611 1505 A9 01                 LDA   #READ0ADR
1612 1507 2C 7C 03              BIT   SIDE
1613 150A 10 02                 BPL   @10
1614 150C A9 03                 LDA   #READ1ADR
1615 150E 20 3A 16     @10      JSR   READ_BIT
1616 1511 AF EC C0 E1           LDA   >L6CLR
1617 1515 60                    RTS   
1618 1516
1619 1516              ;----------------------------------------
1620 1516                       endp 
